-- events for shaman screen

T_INFO_MOUSE_OVER = Localize ("Hover the cursor over a powerup for information.");


timer = 0
floweramount = 55;
flowerpositions = {}

MAX_TALISMAN_SLOTS = 1;
TOTAL_NUM_TALISMANS = 8;

function OnLoad ()
	CacheSound ("music/shaman.ogg");
	CacheSound("sfx/whoosh1.ogg")
	--SetProperty ("/Shaman:enable_event_on_cursor_enter", 1);	
	NX_GetBitmap("fxs/purplestar.png");
end;



function ShowAllAmuletButtons ()

	num = Azkend_GetNumPowerups ();
	i = 0;
	while (i < num) do
		id = Azkend_GetPowerupID (i);
		--Print ("Showing #" .. i .. ": '" .. id .. "'\n");
		SetProperty ("Amulet_" .. id .. ":visible", 1);
		i = i + 1;
	end;

	--SetProperty ("Amulet_Fire:visible", 1);
	--SetProperty ("Amulet_Waterfall:visible", 1);
	--SetProperty ("Amulet_WaterCross:visible", 1);
	--SetProperty ("Amulet_Luck:visible", 1);
end;


function HideAllAmuletButtons ()

	num = Azkend_GetNumPowerups ();
	i = 0;
	while (i < num) do
		id = Azkend_GetPowerupID (i);
		--Print ("Hiding #" .. i .. ": '" .. id .. "'\n");
		SetProperty ("Amulet_" .. id .. ":visible", 0);
		i = i + 1;
	end;
end;




function UpdatePowerupIcons ()
	
	ShowAllAmuletButtons ();
	
	
	i = 1;
	
	while (i <= TOTAL_NUM_TALISMANS) do
		name = Azkend_GetPowerupID(i-1);
		
		active = GetGameValue ("powerup_unlocked_".. name);
		Print (i .. " is " .. name .. "\n");

		SetProperty ("Amulet_"..name..":active", 1);
		
		if (active) then
			SetProperty ("Amulet_"..name..":visible", 1);
		else
			SetProperty ("Amulet_"..name..":visible", 0);
		end;
		
	

		i = i + 1;
	end;
	
	--Print ("Listed.\n");

	i = 0;
	while (i < MAX_TALISMAN_SLOTS) do
		index = Azkend_GetSlotPowerup (i);
		SetProperty ("Slot" .. (i+1) .. ":button.bm_icon", Azkend_GetPowerupBitmap (index));
	  
		id = Azkend_GetPowerupID (index);

		--Print ("Slot " .. i .. "id is " .. id .. "\n");

		SetProperty ("Amulet_" .. id .. ":active", 0);

		i = i + 1;
	end;
	

end;

function UpdateTalismanDesc ()

	local index = Azkend_GetSlotPowerup (0);
	local name = Azkend_GetPowerupName (index);
	local desc = Azkend_GetPowerupDesc (index);
	if(name == "!NONE") then
		return;
	end;
	SetProperty ("name:label.text", name);
	SetProperty ("desc:label.text", desc);
	SetProperty ("big_talisman_bm:label.bitmap", Azkend_GetPowerupBitmapBig (index));
end;


function OnEnter ()

	Azkend_SetMenuBackground ("worldmap/backgrounds/bg-0006.jpg");


    PlaySound("sfx/whoosh1.ogg")
	UpdatePowerupIcons ();
 	SetProperty ("/Shaman:enter_trans_duration", 0.45);
    SetProperty ("/Shaman:leave_trans_duration", 0.45);
	SwitchMusic ("music/shaman.ogg", 2, 3);
	
	for i = 1, floweramount, 1 do
  		temp = {}
		y = math.random(40,700);
		temp.y = y - (y*2);		
		temp.x = math.random(0,800);
		table.insert(flowerpositions, i, temp);
  	end;
  	
  	UpdateTalismanDesc ();
  	
	if (Azkend_AutoplayerActive ()) then
		SwitchScreen("WorldMap");
	end;  	
end;

function OnLeave ()

end;



function UnlockAll ()
	Print ("Unlocking all powerups...\n");
	i = 1;
	while (i <= TOTAL_NUM_TALISMANS) do
		SetGameValue ("powerup_unlocked_".. Azkend_GetPowerupID(i-1),  true);
		i = i + 1;
	end;
	--SetGameValue ("powerup_unlocked_JadeBomb", false);

end;

function LockAll ()
	Print ("Locking all powerups...\n");
	i = 1;
	while (i <= TOTAL_NUM_TALISMANS) do
		name = Azkend_GetPowerupID(i-1);
		Print ("Locking " .. name .. "\n");
		SetGameValue ("powerup_unlocked_"..name, false);
		i = i + 1;
	end;
	
end;



function OnClick (name)

	Print ("OnClick " .. name .. "\n");
		
	if (name == "Ok") then	
	    PlaySound("sfx/whoosh1.ogg")
		SwitchScreen("WorldMap");
		return;
	end;
	
	
	if (name == "Unlock All") then
		UnlockAll ();		
		UpdatePowerupIcons ();
	end;		
	if (name == "Lock All") then
		LockAll ();		
		UpdatePowerupIcons ();
	end;	


	-- For testing purposes (see if all powerups are included in string search)
	if (name == "Hide") then
		HideAllAmuletButtons ();
	end;
	if (name == "Show") then
		ShowAllAmuletButtons ();
	end;

	-- Add powerups to slots on click (provided there's space)
	if (string.find(name, "Amulet_")) then
			index = Azkend_GetSlotPowerup (0);
			Azkend_UnselectPowerup (index);
			index = Azkend_PowerupIndexByName (name);
			Azkend_SelectPowerup (name);
			
			UpdateTalismanDesc ();
			
			UpdatePowerupIcons ();
	end;

	-- Remove powerups from the slots on click
	i = 0;
	while (i < MAX_TALISMAN_SLOTS) do
		slot_name = "Slot" .. (i+1);
		if (name == slot_name) then
			index = Azkend_GetSlotPowerup (i);
			Azkend_UnselectPowerup (index);
			UpdatePowerupIcons ();
		end;
		i = i + 1;
	end;

	
end;


function OnUpdate (tdelta)

	timer = timer+tdelta
	
	
	alpha = GetActiveScreenTransPhase ();
	
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	--SetProperty ("panel:position_offset.y", (1-trans) * 600);
	
	--SetProperty ("fader:alpha", alpha);
	
	--SetProperty ("panel:alpha", GetActiveScreenTransPhase ());
	
	for i = 1, floweramount, 1 do
		if(flowerpositions[i]["y"] < 700) then
			flowerpositions[i]["y"] = flowerpositions[i]["y"] + (30 * tdelta);		
		else	
  			--Print("ENDFLOWERFLY flower" .. i .. "\n");
  			y = math.random(40,700);
			y = y - (y*2);		
			x = math.random(0,800);
			flowerpositions[i]["y"] = y
			flowerpositions[i]["x"] = x
		end;
		
	end;
	
end;



function OnCursorEnter (name)


end;


function OnDraw ()
	NX_SetBlend ("ADDITIVE")
	for i = 1, floweramount, 1 do
		sinewave = 35 * math.sin((flowerpositions[i]["y"] / 80));
		rotationsine = 25 * math.sin((flowerpositions[i]["y"] / 30));
		--scale = flowerpositions[i]["y"] / 800 + 0.5;
		
		scale = math.sin((flowerpositions[i]["y"] / 30))/2 + 0.5
		NX_DrawBitmapRS ("fxs/purplestar.png", flowerpositions[i]["x"]+sinewave, flowerpositions[i]["y"], rotationsine/180*3.1415926535, scale);
	end;
	NX_SetBlend ("NORMAL")
	
	font = GetProperty ("name:label.font");
	alpha = GetActiveScreenTransPhase ();

	NX_SetAlpha (alpha);

	NX_SetColor (1,0.5,0.1);
	x = GetProperty ("name:static_position.x");
	y = GetProperty ("name:static_position.y");
	


--	NX_DrawText (font, x, y, name);


	NX_SetColor (1,1,1);
	x = GetProperty ("desc:static_position.x");
	y = GetProperty ("desc:static_position.y");

--	NX_DrawText (font, x, y, "desc");

end;

